//=============================================================================
// MSMTLPlayer, no difference other than gadget compatibility.
//
// Custom player class for the MSMTL Add-on
//=============================================================================
class MSMTLPlayer extends MTLPlayer config (MSMTL); 

var int Metals, Spices, Sugar, Fruit, Soy, Chocolate, Bread; //how many resources do we currently have?
var() globalconfig int StartMetals, StartSpices, StartSugar, StartFruit, StartSoy, StartChocolate, StartBread; //what resources do we start with
var() globalconfig bool bCanAirJump; //can we double jump?
var bool bAlreadyJumped; //did we double jump?
var() globalconfig bool bStartWithPot, bStartWithAnvil; //do we start with these gadgets?
var() globalconfig bool bAutoArmsMode; //do we start out with markistan guns?
var() globalconfig bool bReplaceHUD; //Important!

//Broop Special!
var() globalconfig bool bNoSayAlert;

var int LivesLeft;

var Actor CurSpectator;
var int ArmorComposition; //0 = None, 1 = Reload Rig, 2 = Melee Resist, 3 = Bullet Resist, 4 = Bullet Resist 2, 5 = Blast Resist, 
var float HasteRating, SpeedRating; //, TimeAlive;

//NEW: For debugging!
var travel string CountClasses[8];
var travel bool bMegaTest;
var name TName;
var bool CountNextTick;

replication
{
	reliable if( Role<ROLE_Authority )
          Dance, PM, MSSingleGet, MSSingleSet, MSCheckName, MSSelfSet, MSRepliSet, MSSelfRepliSet, MSStateSet;
        reliable if(Role==ROLE_Authority)
 	  PlayDancing;
	
	//NEW! Maintain this timer properly!
        //reliable if(Role==ROLE_Authority)
 	//  TimeAlive;

}

//3/26/20: Use this to stop us from frobbing shit when dead. Whoops.
state CheatFlyingButDead
{
ignores SeePlayer, HearNoise, Bump, TakeDamage;
		
	function AnimEnd()
	{
		PlaySwimming();
	}
	
	function ProcessMove(float DeltaTime, vector NewAccel, eDodgeDir DodgeMove, rotator DeltaRot)	
	{
		Acceleration = Normal(NewAccel);
		Velocity = Normal(NewAccel) * 300;
		AutonomousPhysics(DeltaTime);
	}

	event PlayerTick( float DeltaTime )
	{
		if ( bUpdatePosition )
			ClientUpdatePosition();

		PlayerMove(DeltaTime);
	}

	function PlayerMove(float DeltaTime)
	{
		local rotator newRotation;
		local vector X,Y,Z;

		GetAxes(ViewRotation,X,Y,Z);

		aForward *= 0.1;
		aStrafe  *= 0.1;
		aLookup  *= 0.24;
		aTurn    *= 0.24;
		aUp		 *= 0.1;
	
		Acceleration = aForward*X + aStrafe*Y + aUp*vect(0,0,1);  

		UpdateRotation(DeltaTime, 1);

		if ( Role < ROLE_Authority ) // then save this move and replicate it
			ReplicateMove(DeltaTime, Acceleration, DODGE_None, rot(0,0,0));
		else
			ProcessMove(DeltaTime, Acceleration, DODGE_None, rot(0,0,0));
	}

	function BeginState()
	{
		EyeHeight = BaseEyeHeight;
		SetPhysics(PHYS_Flying);
		if  ( !IsAnimating() ) PlaySwimming();
		// log("cheat flying");
	}
}

exec function DumpNotes()
{
 local string S;
 local DeusExNote Note;
 local int i;
 
 for(Note=FirstNote; Note!=None; Note=Note.Next)
 {
  if (i > 200) break;
  if (Note == None) break;
  
  i++;
  S = Note.Text;
  Log(S);
 }
}

exec function AddCountClass(int i, string S)
{
 local bool LoadWin;
 
 if (Level.NetMode != NM_Standalone) return;
 if (i == -1)
 {
  bMegaTest = True;
 }
 
 if (InStr(S, ".") == -1) S = "DeusEx."$S;
 i = Clamp(i, 0, 7);
 
 LoadWin = (class<Actor>(DynamicLoadObject(S, class'Class', True)) != None);
 
 if (LoadWin)
 {
  ClientMessage(S@"Added to Count Classes!");
  CountClasses[i] = S;
 }
 else
 {
  ClientMessage("Unrecognized class"@S$"!");
 }
 
 ProcessCounting();
}

/*function PlayerTick(float DT)
{
 Super.PlayerTick(DT);
 
 if ((Level.Netmode == NM_Standalone) && (CountNextTick))
 {
  BroadcastMessage("COUNTING");
  ProcessCounting();
  CountNextTick = False;
 }
}*/

function ProcessCounting()
{
 local int i;
 
 if (bMegaTest)
 {
  if (ReducedDamageType != 'All') ConsoleCommand("God");
  ConsoleCommand("AugAdd AugSpeed");
  ConsoleCommand("Set DeusExPlayer Energy 9999");
  ConsoleCommand("Set AugSpeed CurrentLevel 3");
  ConsoleCommand("Set SkillSwimming CurrentLevel 3");
  SemiGhostDoors();
 }
 
 for (i=0; i<8; i++)
 {
  if (CountClasses[i] != "")
  {
   CountActors(CountClasses[i]);
  }
 }
}

event TravelPostAccept()
{
 local int i;
 
 Super.TravelPostAccept();
 
 if (Level.Netmode == NM_Standalone)
 {
  //BroadcastMessage("COUNT NEXT");
  CountNextTick = True;
  //ProcessCounting();
 }
 
 
}

function SemiGhostDoors()
{
 local DeusExMover D;
 
 forEach AllActors(class'DeusExMover', D)
 {
  if (D != None)
  {
   D.SetCollision(False, True, True);
  }
 }
}

function CountActors(string S)
{
 local bool MatchFlag, bDebug;
 local int TCount;
 local string TMap, TStr, TClass, TContents, TItem;
 local Actor A;
 
 TMap = GetURLMap();
 
 SetPropertyText("TName", S);
 bDebug = False;
 
 TItem = CAPS(Right(S, Len(S) - 1 - InStr(S, ".")));
 forEach AllActors(class'Actor', A)
 {
  if ((A != None) && (TName != ''))
  {
   TClass = CAPS(String(A.Class));
   TContents = CAPS(A.GetPropertyText("Contents"));
   
   if ((bDebug) && (Frand() < 0.05)) ClientMessage(TClass@TContents@TItem);
   
   MatchFlag = False;
   if (InStr(TClass, TItem) > -1) MatchFlag = True;
   if (InStr(TContents, TItem) > -1) MatchFlag = True;
   
   if (MatchFlag)
   {
    TCount++;
   }
  }
 }
 
 if (TCount > 0)
 {
  TStr = TMap@S$":"@TCount;
  
  if (!HasNote(TMap$" ", TItem))
  {
   AddNote(TStr, True, True);
  }
  else
  {
   ClientMessage("Note"@TMap@"considered duplicate!");
  }
 }
 else
 {
  ClientMessage("No actor classes found for"@S$"!");
 }
}

function bool HasNote(String S, string S2)
{
 local DeusExNote Note;
 
 if (InStr(CAPS(S), ".DXS") > -1) return True;
 
 for(Note=FirstNote; Note!=None; Note=Note.Next)
 {
  if (Note == None) Break;
  
  if ((InStr(CAPS(Note.Text), CAPS(S)) > -1)  &&  (InStr(CAPS(Note.Text), CAPS(S2)) > -1))
  {
   return True;
  }
 }
 
 return False;
}

event Possess()
{ 
    local DeusExRootWindow root; 

    Super.Possess();
    
    if (bReplaceHud)
    {
    	root = DeusExRootWindow(rootWindow);
    	root.hud.Destroy();
    	root.hud = BroopHUD(root.NewChild(Class'BroopHUD'));
    	root.hud.UpdateSettings(Self); 
    	root.hud.SetWindowAlignments(HALIGN_Full,VALIGN_Full, 0, 0);
    }
    else
    {
    	root = DeusExRootWindow(rootWindow);
    	root.hud.Destroy();
    	root.hud = BroopHUDLight(root.NewChild(Class'BroopHUDLight'));
    	root.hud.UpdateSettings(Self); 
    	root.hud.SetWindowAlignments(HALIGN_Full,VALIGN_Full, 0, 0);
    }
    //SetTimer(1.0,True);
}

/*function InitializeSubSystems()
{
	// Spawn the BarkManager
	if (BarkManager == None)
		BarkManager = Spawn(class'BarkManager', Self);

	// Spawn the Color Manager
	CreateColorThemeManager();
    ThemeManager.SetOwner(self);

	// install the augmentation system if not found
	if (AugmentationSystem == None)
	{
		AugmentationSystem = Spawn(class'BroopAugmentationManager', Self);
		AugmentationSystem.CreateAugmentations(Self);
		AugmentationSystem.AddDefaultAugmentations();        
        AugmentationSystem.SetOwner(Self);       
	}
	else
	{
		AugmentationSystem.SetPlayer(Self);
        AugmentationSystem.SetOwner(Self);
	}

	// install the skill system if not found
	if (SkillSystem == None)
	{
		SkillSystem = Spawn(class'SkillManager', Self);
		SkillSystem.CreateSkills(Self);
	}
	else
	{
		SkillSystem.SetPlayer(Self);
	}

   if ((Level.Netmode == NM_Standalone) || (!bBeltIsMPInventory))
   {
      // Give the player a keyring
      CreateKeyRing();
   }
}*/

function Landed(vector HitNormal)
{
    local vector legLocation;
	local int augLevel;
	local float augReduce, dmg;

	//Note - physics changes type to PHYS_Walking by default for landed pawns
	PlayLanded(Velocity.Z);
	if (Velocity.Z < -1.4 * JumpZ)
	{
		MakeNoise(-0.5 * Velocity.Z/(FMax(JumpZ, 150.0)));
		if ((Velocity.Z < -700) && (ReducedDamageType != 'All'))
			if ( Role == ROLE_Authority )
            {
				// check our jump augmentation and reduce falling damage if we have it
				// jump augmentation doesn't exist anymore - use Speed instaed
				// reduce an absolute amount of damage instead of a relative amount
				augReduce = 0;
				if (AugmentationSystem != None)
				{
					augLevel = AugmentationSystem.GetClassLevel(class'AugSpeed');
					if (AugLevel < 0) augLevel = AugmentationSystem.GetClassLevel(class'BroopAugSpeed');
					if (augLevel >= 0)
						augReduce = 15 * (augLevel+1);
				}

				dmg = Max((-0.16 * (Velocity.Z + 700)) - augReduce, 0);
				legLocation = Location + vect(-1,0,-1);			// damage left leg
				TakeDamage(dmg, None, legLocation, vect(0,0,0), 'fell');

				legLocation = Location + vect(1,0,-1);			// damage right leg
				TakeDamage(dmg, None, legLocation, vect(0,0,0), 'fell');

				dmg = Max((-0.06 * (Velocity.Z + 700)) - augReduce, 0);
				legLocation = Location + vect(0,0,1);			// damage torso
				TakeDamage(dmg, None, legLocation, vect(0,0,0), 'fell');
            }
	}
	else if ( (Level.Game != None) && (Level.Game.Difficulty > 1) && (Velocity.Z > 0.5 * JumpZ) )
		MakeNoise(0.1 * Level.Game.Difficulty);				
	bJustLanded = true;
}

function float GetSpeedMult()
{
 local float Ret;
 
 //More math hacks. Beautiful.
 Ret = Abs(SpeedRating - 2.0);
 
 //Penalties for scoping and reloading.
 if (HatchetWeapon(InHand) != None)
 {
  if (HatchetWeapon(inHand).bADS || HatchetWeapon(inHand).bZoomed) Ret *= 0.65;
  if (HatchetWeapon(inHand).IsInState('Reload')) Ret *= 0.8;
 }
 
 //Empty hands now grant 25% move speed boost.
 if (InHand == None)
 {
  Ret *= 1.25;
 }
 //Light weapons offer more boost, and heavy weapons a speed penalty.
 else if ((HatchetWeapon(InHand) != None) && (HatchetWeapon(InHand).MoveSpeedMultiplier > 0))
 {
  Ret *= HatchetWeapon(InHand).MoveSpeedMultiplier;
 }
 
 return Ret;
}

function float GetCurrentGroundSpeed()
{
	local float augValue, speed;

	// Remove this later and find who's causing this to Access None MB
	if ( AugmentationSystem == None )
		return 0;

   augValue = AugmentationSystem.GetAugLevelValue(class'AugSpeed');
   if (AugValue < 0)   augValue = AugmentationSystem.GetAugLevelValue(class'BroopAugSpeed');

	if (augValue == -1.0)
		augValue = 1.0;

	if (( Level.NetMode != NM_Standalone ) && Self.IsA('Human') )
		speed = mpGroundSpeed * augValue * GetSpeedMult();
	else
		speed = Default.GroundSpeed * augValue * GetSpeedMult();

	return speed;
}

//Convert augs to broop versions! Hot damn, this is slick!
function Class<Augmentation> TranslateAug(Augmentation InAug)
{
 if (InAug.Class == class'AugSpeed') return class'BroopAugSpeed';
 
 return InAug.Class;
}

//WARNING: This function might be highly destabilizing when used with map travel!
/*function AddInsurgentAugs()
{
 local Augmentation CurrentAug;
 
      for (CurrentAug = AugmentationSystem.FirstAug; CurrentAug != None; CurrentAug = CurrentAug.next)
      {
       if (CurrentAug.Next == None)
       {
	//Fucking end me.
	
	//SPEED AUG!
	CurrentAug.Next = Spawn(Class'BroopAugSpeed', AugmentationSystem);
	CurrentAug = CurrentAug.Next;
	CurrentAug.Player = Self;
	break;
       }
      }
}*/

//===================================
//HOLY SHIT. MOTHER OF HACK!
/*function GrantAugs(int NumAugs)
{
   local Augmentation CurrentAug, HackAug;
   local int PriorityIndex;
   local int AugsLeft;
   local class<Augmentation> CAG;
   
   //Removing for further testing.
   //if (AugmentationSystem.FindAugmentation(class'BroopAugSpeed') == None) AddInsurgentAugs();
   
   if (Role < ROLE_Authority)
      return;
   AugsLeft = NumAugs;

   for (PriorityIndex = 0; PriorityIndex < ArrayCount(AugPrefs); PriorityIndex++)
   {
      if (AugsLeft <= 0)
      {
         return;
      }
      if (AugPrefs[PriorityIndex] == '')
      {
         return;
      }
      for (CurrentAug = AugmentationSystem.FirstAug; CurrentAug != None; CurrentAug = CurrentAug.next)
      {
         if ((CurrentAug.Class.Name == AugPrefs[PriorityIndex]) && (CurrentAug.bHasIt == False))
         {
		 CAG = TranslateAug(CurrentAug);
		 
	         HackAug = AugmentationSystem.GivePlayerAugmentation(CAG);
				// Max out aug
				if (HackAug.bHasIt)
					HackAug.CurrentLevel = HackAug.MaxLevel;
            AugsLeft = AugsLeft - 1;
         }
      }
   }
}*/

/*function ServerReStartPlayer()
{
 Super.ServerReStartPlayer();
 
 TimeAlive = 0;
}*/

/*state Dying
{
ignores SeePlayer, HearNoise, KilledBy, Bump, HitWall, HeadZoneChange, FootZoneChange, ZoneChange, SwitchWeapon, Falling, PainTimer;

	function ServerReStartPlayer()
	{
	 Super.ServerReStartPlayer();
	 TimeAlive = 0;
	}
}*/

/*function Died(pawn Killer, name damageType, vector HitLocation)
{
 Super.Died(Killer, DamageType, HitLocation);
 
 //if (TimeAlive < 5) LivesLeft += 1;
}*/

function PlayDyingSound()
{
	if (Region.Zone.bWaterZone)
	{
		if (bIsFemale) PlaySound(sound'FemaleWaterDeath', SLOT_Pain,,,, RandomPitch());
		else PlaySound(sound'MaleWaterDeath', SLOT_Pain,,,, RandomPitch());
	}
	else
	{
		if (bIsFemale) PlaySound(sound'FemaleDeath', SLOT_Pain,,,, RandomPitch());
		else PlaySound(sound'MaleDeath', SLOT_Pain,,,, RandomPitch());
	}
}

function Gasp()
{
	if (bIsFemale) PlaySound(sound'MaleGasp', SLOT_Pain,,,, RandomPitch()*1.5);
	else PlaySound(sound'MaleGasp', SLOT_Pain,,,, RandomPitch());
}

function PlayTakeHitSound(int Damage, name damageType, int Mult)
{
	local float rnd;

	if ( Level.TimeSeconds - LastPainSound < FRand() + 0.5)
		return;

	LastPainSound = Level.TimeSeconds;

	if (Region.Zone.bWaterZone)
	{
		if (damageType == 'Drowned')
		{
			if (FRand() < 0.8)
			{
				if (bIsFemale) PlaySound(sound'FemaleDrown', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
				else PlaySound(sound'MaleDrown', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
			}
		}
		else
		{
			//Female land is better than painsmall, but still fucking sucks ass.
			if (bIsFemale) PlaySound(sound'FemaleLand', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
			else PlaySound(sound'MalePainSmall', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
		}
	}
	else
	{
		// Body hit sound for multiplayer only
		if (((damageType=='Shot') || (damageType=='AutoShot'))  && ( Level.NetMode != NM_Standalone ))
		{
			PlaySound(sound'BodyHit', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
		}

		if ((damageType == 'TearGas') || (damageType == 'HalonGas'))
		{
			//Yet more bad sounds...
			if (bIsFemale) PlaySound(sound'FemalePainMedium', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
			else PlaySound(sound'MaleEyePain', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
		}
		else if (damageType == 'PoisonGas')
		{
			//God forsaken sounds...
			if (bIsFemale) PlaySound(sound'FemalePainSmall', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
			else PlaySound(sound'MaleCough', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
		}
		else
		{
			rnd = FRand();
			if (rnd < 0.33)
			{
				if (bIsFemale) PlaySound(sound'FemaleLand', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
				else PlaySound(sound'MalePainSmall', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
			}
			else if (rnd < 0.66)
			{
				if (bIsFemale) PlaySound(sound'FemalePainMedium', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
				else PlaySound(sound'MalePainMedium', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
			}
			else
			{
				if (bIsFemale) PlaySound(sound'FemalePainLarge', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
				else PlaySound(sound'MalePainLarge', SLOT_Pain, FMax(Mult * TransientSoundVolume, Mult * 2.0),,, RandomPitch());
			}
		}
		AISendEvent('LoudNoise', EAITYPE_Audio, FMax(Mult * TransientSoundVolume, Mult * 2.0));
	}
}

//++++++++++++++++++++++++++++
//APPLY HASTE RATING!
function bool AddInventory(inventory item)
{
 if (item.IsA('HatchetWeapon'))
 {
  HatchetWeapon(item).HasteRating = HasteRating;
 }
 
 return Super.AddInventory(item);
}

//Because weight doesn't alway equal size. With encumberance this is
//a large problem, not all 2 handed weapons weigh the same, or even should
//weight more than 30 lbs, so lets just use a bool.
//EDIT: Now with parry compatability!
function Bool HasTwoHandedWeapon()
{
	if (Weapon != None)
	{
	 if (Weapon.Isa('HatchetWeapon'))
	 {
	  if ((HatchetWeapon(Weapon).bTwoHanded) || (Weapon.Mass >= 30) || (DeusExWeapon(Weapon).bHandToHand && HatchetWeapon(Weapon).bADS))
	   return True;
	 }
	 else
	  return False;
	}
}

/*function DoFrob(Actor Frobber, Inventory frobWith)
{
	local DeusExRootWindow root;
	local Ammo ammo;
	local Inventory item;
	local Actor A;
	
	local BroopBrofileMutator BBM;
	
	Super.DoFrob(Frobber, frobWith);
	
	Mutate("Issue Broop Order");
}*/

exec function ParseRightClick()
{
 Super.ParseRightClick();
 
 Mutate("Issue Broop Order");
}

function bool IsLiving(Actor CS)
{
 if (CS == None) return False;
 
 if (CS.IsInState('Dying')) return False;
 if (CS.IsInState('Spectating')) return False;
 if (CS.IsInState('CheatFlyingButDead')) return False;
 
 return True;
}

function DeusExPlayer GetLivingPlayer()
{
 local DeusExPlayer DXP;
 
 forEach AllActors(class'DeusExPlayer', DXP)
 {
  if (IsLiving(DXP))
  {
   return DXP;
  }
 }
 
 return None;
}


state Spectating
{
	ignores all;

	event PlayerTick(float deltaTime)
	{
	 if (!IsLiving(CurSpectator) && GetLivingPlayer() != None) CurSpectator = GetLivingPlayer();

		Super.PlayerTick(deltaTime);
	}

	exec function Fire(optional float F)
	{
	}

	exec function ShowMainMenu()
	{
		// reduce the white glow when the menu is up
		if (InstantFog != vect(0,0,0))
		{
			InstantFog   = vect(0.1,0.1,0.1);
			InstantFlash = 0.01;

			// force an update
			ViewFlash(1.0);
		}

		Global.ShowMainMenu();
	}

	function BeginState()
	{
	}

   function TakeDamage(int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType)
	{
	}

	function PlayerCalcView(out actor ViewActor, out vector CameraLocation, out rotator CameraRotation)
	{
		local vector ViewVect, HitLocation, HitNormal, whiteVec;
		local float ViewDist;
		local actor HitActor;
		local float time;

		ViewActor = CurSpectator;

			if (CurSpectator != None)
			{
				CameraLocation = CurSpectator.Location + Pawn(CurSpectator).BaseEyeheight * vect(0,0,1);
				CameraRotation = Pawn(CurSpectator).ViewRotation;
			}
	}

Begin:
	GoTo('Begin');
}




//Team acrobatics go.
singular function SupportActor(Actor standingActor)
{
 if (PlayerPawn(StandingActor) != None)
 {
  standingActor.SetBase(self);
 }
 else
  Super.SupportActor(StandingActor);
}



singular event BaseChange()
{
	local float decorMass;

	if ( (base == None) && (Physics == PHYS_None) )
		SetPhysics(PHYS_Falling);
	else if (Pawn(Base) != None && PlayerPawn(Base) == None)
	{
		Base.TakeDamage( (1-Velocity.Z/400)* Mass/Base.Mass, Self,Location,0.5 * Velocity , 'stomped');
		JumpOffPawn();
	}
	else if ( (Decoration(Base) != None) && (Velocity.Z < -400) )
	{
		decorMass = FMax(Decoration(Base).Mass, 1);
		Base.TakeDamage((-2* Mass/decorMass * Velocity.Z/400), Self, Location, 0.5 * Velocity, 'stomped');
	}
}


//NOW READOUT CREDITS!
exec function ShowInventoryWindow()
{
	if (RestrictInput())
		return;

   if ((Level.NetMode != NM_Standalone) && (bBeltIsMPInventory))
   {
      //ClientMessage("Credits:"@Credits);
      Mutate("Broop Credits");
      return;
   }

	InvokeUIScreen(Class'PersonaScreenInventory');
}

//Tell us current objectives.
exec function ShowGoalsWindow()
{
 local string Goals[4];
 local BroopGoalUnit BGU;
 local int j, k;
 
	if (RestrictInput())
		return;
	   
   if ((Level.NetMode != NM_Standalone) && (bBeltIsMPInventory))
   {
    Mutate("Get Broop Goals");
    
    return;
   }
   
   InvokeUIScreen(Class'PersonaScreenGoals');
}

exec function Say( string Msg )
{
 Super.Say(Msg);
 
 if (!bNoSayAlert)
 {
  AISendEvent('LoudNoise', EAITYPE_Audio, , 192);
  AISendEvent('LoudNoise', EAITYPE_Audio, , 192);
  AISendEvent('LoudNoise', EAITYPE_Audio, , 192);
  AISendEvent('LoudNoise', EAITYPE_Audio, , 192);
  AISendEvent('LoudNoise', EAITYPE_Audio, , 192);
 }
}

function bool HandleItemPickup (Actor FrobTarget, optional bool bSearchOnly)
{
	local bool bCanPickup;
	local Inventory foundItem;

	if (FrobTarget.IsA('Dollar') || FrobTarget.IsA('Dollar2') || FrobTarget.IsA('MSMTLCookingSupplies') || FrobTarget.IsA('MSMTLMetals') )
	{
		bCanPickup = True;
		DoFrob(self,inHand);
	}

        if (!FrobTarget.IsA('Dollar') && !FrobTarget.IsA('Dollar2') && !FrobTarget.IsA('MSMTLCookingSupplies') && !FrobTarget.IsA('MSMTLMetals') )
        { 
         bCanPickup = Super(MTLPlayer).HandleItemPickup(FrobTarget, bSearchOnly);
        }

	return bCanPickup;
}

exec function editActor()
{
}

exec function MSOwnerSet(optional Actor NewOwner)
{
 	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
	local ScriptedPawn     hitPawn;
	local DeusExMover      hitMover;
	local DeusExDecoration hitDecoration;

	if (!bCheatsEnabled)
		return;
	
	if (NewOwner == None) NewOwner = Self;
	
	position    = Location;
	position.Z += BaseEyeHeight;
	line        = Vector(ViewRotation) * 4000;
	
	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if (hitActor != None && hitActor != Level)
	{
         hitActor.SetOwner(Self);
	 ClientMessage("|p3"$hitActor$"'s Owner is now "$Self$"!");
	 return;
        }

	 ClientMessage("|cf88000Error: No target to set.");
}

exec function MSCheckName()
{
	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
	local ScriptedPawn     hitPawn;
	local DeusExMover      hitMover;
	local DeusExDecoration hitDecoration;

	if (!bCheatsEnabled)
		return;

	position    = Location;
	position.Z += BaseEyeHeight;
	line        = Vector(ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if (hitActor != None && hitActor != Level)
	{
	 ClientMessage("|p3This actor is "$hitActor$"!");
	 return;
        }
}

exec function MSForceAnim(name TAnimName, float TAnimRate, optional bool bLoop, optional name TAnimName2)
{
	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
	local ScriptedPawn     hitPawn;
	local DeusExMover      hitMover;
	local DeusExDecoration hitDecoration;

	if (!bCheatsEnabled)
		return;

	position    = Location;
	position.Z += BaseEyeHeight;
	line        = Vector(ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if (hitActor != None && hitActor != Level)
	{
	 if (TAnimName2 == '' || TAnimName2 == 'None')
	 {
	  if (!bLoop) HitActor.PlayAnim(TAnimName, TAnimRate, 0.1);
	  else HitActor.LoopAnim(TAnimName, TAnimRate, 0.1);
          ClientMessage("|p3"$hitActor$" will now play"@TAnimName$"!");
          return;
	 }
	 else
	 {
	  if (!bLoop) HitActor.PlayAnim(TAnimName, TAnimRate, 0.1);
	  else HitActor.LoopAnim(TAnimName, TAnimRate, 0.1);
	  
	  HitActor.PlayBlendAnim(TAnimName2, TAnimRate, 0.1);
          ClientMessage("|p3"$hitActor$" will now play"@TAnimName$"!");
          return;
	 }
        }	
}

exec function MSSingleGet(string proptoget)
{
	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
	local ScriptedPawn     hitPawn;
	local DeusExMover      hitMover;
	local DeusExDecoration hitDecoration;

	if (!bCheatsEnabled)
		return;

	position    = Location;
	position.Z += BaseEyeHeight;
	line        = Vector(ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if ((hitActor != None) && (hitActor != Level))
	{
          ClientMessage("|p3"$hitActor$"'s property of "$proptoget$" reads '"$hitActor.GetPropertyText(proptoget)$"'!");
          return;
        }
}

exec function MSSelfGet(string proptoget)
{
	if (!bCheatsEnabled)
		return;
	
	ClientMessage("|p3Your property of "$proptoget$" reads '"$GetPropertyText(proptoget)$"'!");
	return;
}

exec function MSInvGet(string proptoget)
{
	if (!bCheatsEnabled)
		return;
	
	if (InHand == None)
		return;
	
        ClientMessage("|p3"$InHand$"'s property of "$proptoget$" reads '"$InHand.GetPropertyText(proptoget)$"'!");
	return;
}


exec function MSSingleSet(string proptomod)
{
	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
	local ScriptedPawn     hitPawn;
	local DeusExMover      hitMover;
	local DeusExDecoration hitDecoration;
        local string SetA, SetB;
        local int i;

	i = InStr(proptomod, " ");       
        SetA = Left(proptomod, i );
        SetB = Right(proptomod, Len(proptomod) - i - 1);

	if (!bCheatsEnabled)
		return;

	position    = Location;
	position.Z += BaseEyeHeight;
	line        = Vector(ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if (hitActor != None && hitActor != Level)
	{
         if (hitActor.GetPropertyText(SetA) == "")
         {
          ClientMessage("|p2ERROR! unrecognized property: '"$SetA$"' in class "$hitActor.Class$"!");
          return;
         }
         else
         {
          if (hitActor != Level)
          {
          hitActor.SetPropertyText(SetA, SetB);
          ClientMessage("|p3"$hitActor$" has had its property "$SetA$" set to "$SetB$"!");
          return;
          }
          else
          {
           ClientMessage("|p2The wall is geometry, not an actor!");
           return;
          }
         }
        }
}

exec function MSStateSet(name StateToBe)
{
	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
	local ScriptedPawn     hitPawn;
	local DeusExMover      hitMover;
	local DeusExDecoration hitDecoration;

	if (!bCheatsEnabled)
		return;

	position    = Location;
	position.Z += BaseEyeHeight;
	line        = Vector(ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if (hitActor != None && hitActor != Level)
	{
          hitActor.GoToState(StateToBe);
          ClientMessage("|p3"$hitActor$" is now in the state "$hitActor.GetStateName()$"!");
          return;
        }
}

exec function MSRepliSet(string proptomod)
{
	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
	local ScriptedPawn     hitPawn;
	local DeusExMover      hitMover;
	local DeusExDecoration hitDecoration;
        local string SetA, SetB;
        local int i;

	i = InStr(proptomod, " ");       
        SetA = Left(proptomod, i );
        SetB = Right(proptomod, Len(proptomod) - i - 1);

	if (!bCheatsEnabled)
		return;

	position    = Location;
	position.Z += BaseEyeHeight;
	line        = Vector(ViewRotation) * 4000;

	hitActor = Trace(hitLocation, hitNormal, position+line, position, true);
	if ((hitActor != None) && (hitActor.IsA('PlayerPawn')))
	{
         if (PlayerPawn(hitActor).PlayerReplicationInfo.GetPropertyText(SetA) == "")
         {
          ClientMessage("|p2ERROR! unrecognized property: '"$SetA$"' in class "$PlayerPawn(hitActor).PlayerReplicationInfo.Class$"!");
          return;
         }
         else
         {
          PlayerPawn(hitActor).PlayerReplicationInfo.SetPropertyText(SetA, SetB);
          ClientMessage("|p3"$PlayerPawn(hitActor).PlayerReplicationInfo$" has had its property "$SetA$" set to "$SetB$"!");
          return;
         }
        }
}

exec function MSSelfSet(string proptomod)
{
        local string SetA, SetB;
        local int i;

	i = InStr(proptomod, " ");       
        SetA = Left(proptomod, i );
        SetB = Right(proptomod, Len(proptomod) - i - 1);

	if (!bCheatsEnabled)
		return;

  if (GetPropertyText(SetA) == "")
  {
          ClientMessage("|p2ERROR! unrecognized property: '"$SetA$"' in class "$Class$"!");
          return;
  }
  else
  {
   SetPropertyText(SetA, SetB);
   ClientMessage("|p3You have set your property of "$SetA$" to "$SetB$"!");
   return;
  }
}

exec function MSSelfRepliSet(string proptomod)
{
        local string SetA, SetB;
        local int i;

	i = InStr(proptomod, " ");       
        SetA = Left(proptomod, i );
        SetB = Right(proptomod, Len(proptomod) - i - 1);

	if (!bCheatsEnabled)
		return;

  if (PlayerReplicationInfo.GetPropertyText(SetA) == "")
  {
          ClientMessage("|p2ERROR! unrecognized property: '"$SetA$"' in class "$PlayerReplicationInfo.Class$"!");
          return;
  }
  else
  {
   PlayerReplicationInfo.SetPropertyText(SetA, SetB);
   ClientMessage("|p3You have set your player replication info's property of "$SetA$" to "$SetB$"!");
   return;
  }
}

exec function Dance()
{
  GoToState('Dancing');
//  PlayDancing();
}

state Dancing
{
 function Timer()
 {
  ClientMessage("|cf88You have stopped dancing");
  StartWalk();
 }

 function BeginState()
 {
  PlayDancing();
  SetTimer(10, False);
 }

/* Begin: PlayDancing();
 SetTimer(10, False);
 GoTo('End');

 End: 

 if (Region.Zone.bWaterZone)
 {
 GoToState('PlayerSwimming');
 }
 else 
 {
//  ClientMessage("|cf88You have stopped dancing.");
  StartWalk();
 }*/
}

function PlayDancing()
{
	local Weapon W;

	if (Region.Zone.bWaterZone)
        {
		LoopAnim('Tread');
                ClientMessage("|p2ERROR: you cannot dance while in water");
        }
	else
        {

	W = Weapon;
	PendingWeapon = None;
	if ( Weapon != None )
		Weapon.PutDown();
	PendingWeapon = W;
		LoopAnim('Dance', FRand()*0.2+0.9, 0.3);
                ClientMessage("|p3You are now dancing! |p2ANIM MAY NOT WORK ON CURRENT MODEL.");
        }
}

exec function PM(int MSMTLRecieverID, string PrivateMessage)
{
	local Pawn P;
	local String str;

	str = "|p6"$PlayerReplicationInfo.PlayerName $ ": " $ PrivateMessage;


	for( P = Level.PawnList; P != None; P = P.nextPawn )
	{
		if(( P.bIsPlayer ) && (P.PlayerReplicationInfo.PlayerID == MSMTLRecieverID))
                {
			P.ClientMessage( str, 'TeamSay', true );
			ClientMessage( str, 'TeamSay', true );

	        if ( Role == ROLE_Authority )
		log( self$" sent the private message '"$PrivateMessage$"' to the player"$P );
                }
	}

	return;
}

/*exec function TeamSay( string Msg )
{
	local Pawn P;
	local String str;
  	local Pawn curPawn;
  	local int bBetterNSF, bBetterUN;

  curPawn = Level.PawnList;

	// Weapons

  if (PlayerReplicationInfo.Team == 0)
  {
        While (curPawn != None)
        {  
         if ((DeusExPlayer(curPawn).PlayerReplicationInfo.Team == 0) && (DeusExPlayer(curPawn).PlayerReplicationInfo.Score > PlayerReplicationInfo.Score))
          bBetterUN = 1;
         curPawn = curPawn.nextPawn;
        }
        bBetterNSF = 2;
  }
  if (PlayerReplicationInfo.Team == 1)
  {
        While (curPawn != None)
        {  
         if ((DeusExPlayer(curPawn).PlayerReplicationInfo.Team == 1) && (DeusExPlayer(curPawn).PlayerReplicationInfo.Score > PlayerReplicationInfo.Score))
          bBetterNSF = 1;
         curPawn = curPawn.nextPawn;
        }
        bBetterUN = 2;
  }
	if ( TeamDMGame(DXGame) == None )
	{
		Say(Msg);
		return;
	}

        if ((bBetterUN == 0) || (bBetterNSF == 0))
	str = "|p4" $PlayerReplicationInfo.PlayerName $ "(Leader): " $ Msg;
        if ((bBetterUN == 1) || (bBetterNSF == 1))
	str = PlayerReplicationInfo.PlayerName $ ": " $ Msg;

	if ( Role == ROLE_Authority )
		log( "TeamSay>" $ str );

	for( P=Level.PawnList; P!=None; P=P.nextPawn )
	{
		if( P.bIsPlayer && (P.PlayerReplicationInfo.Team == PlayerReplicationInfo.Team) )
		{
			if ( P.IsA('DeusExPlayer') )
				DeusExPlayer(P).ClientMessage( str, 'TeamSay', true );
		}
	}
}*/

function GiveInitialInventory()
{
  local actor anItem;
  local int iSkin;
  local Pawn CurPawn;
  local DeusExPlayer curPlayer;
  local bool bBetterNSF, bBetterUN;

  curPawn = Level.PawnList;

	// Weapons

  /*if (PlayerReplicationInfo.Team == 0)
  {
        While (curPawn != None)
        {  
         if ((DeusExPlayer(curPawn).PlayerReplicationInfo.Team == 0) && (DeusExPlayer(curPawn).PlayerReplicationInfo.Score > PlayerReplicationInfo.Score))
          bBetterUN = True;
         curPawn = curPawn.nextPawn;
        }
         for (iSkin = 0; iSkin < ArrayCount(MultiSkins); iSkin++)
         {
        if ((!bBetterUN) && (PlayerReplicationInfo.Score > 0))
        {
         MultiSkins[iSkin] = class'MarkusDouble'.Default.MultiSkins[iSkin];
         Mesh = class'MarkusDouble'.Default.Mesh;
        }
        if ((bBetterUN) || (PlayerReplicationInfo.Score == 0))
        {
         if (PlayerReplicationInfo.Score > 20)
         {
         MultiSkins[iSkin] = class'MarkistanCommando'.Default.MultiSkins[iSkin];
         Mesh = class'MarkistanCommando'.Default.Mesh;
         }
         if (PlayerReplicationInfo.Score < 20)
         {
         MultiSkins[iSkin] = class'MarkistanTroop'.Default.MultiSkins[iSkin];
         Mesh = class'MSMTLUNATCO'.Default.Mesh;
         }
        }
         }
  }
  if (PlayerReplicationInfo.Team == 1)
  {
        While (curPawn != None)
        {  
         if ((DeusExPlayer(curPawn).PlayerReplicationInfo.Team == 1) && (DeusExPlayer(curPawn).PlayerReplicationInfo.Score > PlayerReplicationInfo.Score))
          bBetterNSF = True;
         curPawn = curPawn.nextPawn;
        }
         for (iSkin = 0; iSkin < ArrayCount(MultiSkins); iSkin++)
         {
        if ((!bBetterNSF) && (PlayerReplicationInfo.Score > 0))
        {
         MultiSkins[iSkin] = class'RealFrank'.Default.MultiSkins[iSkin];
         Mesh = class'RealFrank'.Default.Mesh;
        }
        if ((bBetterNSF) || (PlayerReplicationInfo.Score == 0))
        {
         MultiSkins[iSkin] = class'Communist'.Default.MultiSkins[iSkin];
         Mesh = class'MSMTLNSF'.Default.Mesh;
        }
         }
  }
  if (bAutoArmsMode)
  {
  if (PlayerReplicationInfo.Team == 0)
  {
  anItem = Spawn(class'MSMTLSoyMeal2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSRealism1_1.WeaponM162');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  if (bBetterUN)
  {
  anItem = Spawn(class'MSRealism1_1.WeaponDeagle2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSRealism1_1.WeaponBarrett2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  }
  if (!bBetterUN)
  {
  anItem = Spawn(class'MSMTLSoyMeal2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSMTLSoyMeal2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'Markistan.WeaponUSPMATCH');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSRealism1_1.WeaponTacticalShotgun2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  }
  }
  if (PlayerReplicationInfo.Team == 1)
  {
  anItem = Spawn(class'MSMTLSoyMeal3');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSRealism1_1.WeaponUSP2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSRealism1_1.WeaponAK472');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  if (bBetterUN)
  {
  anItem = Spawn(class'MSRealism1_1.WeaponRPG2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  }
  if (!bBetterUN)
  {
  anItem = Spawn(class'MSMTLSoyMeal3');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSMTLSoyMeal3');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'MSRealism1_1.WeaponTacticalShotgun2');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  }
  }
  }
  if(!bAutoArmsMode)
  {*/
  anItem = Spawn(class'DeusEx.Medkit');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  /*}

  Metals = StartMetals * PlayerReplicationInfo.Score;
  Spices = StartSpices * PlayerReplicationInfo.Score;
  Sugar = StartSugar * PlayerReplicationInfo.Score;
  Fruit = StartFruit * PlayerReplicationInfo.Score;
  Soy = StartSoy * PlayerReplicationInfo.Score;
  Chocolate = StartChocolate * PlayerReplicationInfo.Score;
  Bread = StartBread * PlayerReplicationInfo.Score;
 if (bStartWithPot)
 {
  anItem = Spawn(class'MSMTLCookingPot');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
 }
 if (bStartWithAnvil)
 {
  anItem = Spawn(class'MSMTLCraftingAnvil');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
 }*/
  anItem = Spawn(class'DeusEx.LockPick');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  anItem = Spawn(class'DeusEx.MultiTool');
  anItem.Frob(Self,None);
  inventory.bInObjectBelt = True;
  anItem.Destroy();
  
  Credits = 0;
  Metals = 0;
  Spices = 0;
  Sugar = 0;
  Fruit = 0;
  Soy = 0;
  Chocolate = 0;
  Bread = 0;
}

exec function ShowMainMenu()
{
	local DeusExRootWindow root;
	local DeusExLevelInfo info;
	local MissionEndgame Script;

	if (bIgnoreNextShowMenu)
	{
		bIgnoreNextShowMenu = False;
		return;
	}

	info = GetLevelInfo();

	// Special case baby!
	// 
	// If the Intro map is loaded and we get here, that means the player
	// pressed Escape and we want to either A) start a new game 
	// or B) return to the dx.dx screen.  Either way we're going to 
	// abort the Intro by doing this. 
	//
	// If this is one of the Endgames (which have a mission # of 99)
	// then we also want to call the Endgame's "FinishCinematic" 
	// function

	// force the texture caches to flush
	ConsoleCommand("FLUSH");

	if ((info != None) && (info.MissionNumber == 98)) 
	{
		bIgnoreNextShowMenu = True;
		PostIntro();
	}
	else if ((info != None) && (info.MissionNumber == 99))
	{
		foreach AllActors(class'MissionEndgame', Script)
			break;

		if (Script != None)
			Script.FinishCinematic();
	}
	else
	{
		root = DeusExRootWindow(rootWindow);
		if (root != None)
			root.InvokeMenu(Class'MSMTLMenuMain');
	}
}

state PlayerWalking
{


	event PlayerTick( float DeltaTime )
	{
		Super.PlayerTick(DeltaTime);
		
		//TimeAlive += DeltaTime;
		if ((Level.Netmode == NM_Standalone) && (CountNextTick))
		{
		 //BroadcastMessage("COUNTING");
		 ProcessCounting();
		 CountNextTick = False;
		}
	}

	// lets us affect the player's movement
	function ProcessMove ( float DeltaTime, vector newAccel, eDodgeDir DodgeMove, rotator DeltaRot)
	{
		local int newSpeed, defSpeed;
		local name mat;
		local vector HitLocation, HitNormal, checkpoint, downcheck;
		local Actor HitActor, HitActorDown;
		local bool bCantStandUp;
		local Vector loc, traceSize;
		local float alpha, maxLeanDist;
		local float legTotal, weapSkill;
		
		Super.ProcessMove(DeltaTime, newAccel, DodgeMove, DeltaRot);
		
      		// crouching makes you two feet tall
		if (bIsCrouching || bForceDuck)
		{
			if ( Level.NetMode != NM_Standalone )
				SetBasedPawnSize(Default.CollisionRadius, 16.0); //30 before hax
			else
				SetBasedPawnSize(Default.CollisionRadius, 16);
			
			// check to see if we could stand up if we wanted to
			checkpoint = Location;
			// check normal standing height
			checkpoint.Z = checkpoint.Z - CollisionHeight + 2 * GetDefaultCollisionHeight();
			traceSize.X = CollisionRadius;
			traceSize.Y = CollisionRadius;
			traceSize.Z = 1;
			HitActor = Trace(HitLocation, HitNormal, checkpoint, Location, True, traceSize);
			if (HitActor == None)
				bCantStandUp = False;
			else
				bCantStandUp = True;
		}
		
		//Moved!
		//Super.ProcessMove(DeltaTime, newAccel, DodgeMove, DeltaRot);
	}




function DoJump( optional float F )
{
	local DeusExWeapon w;
	local float scaleFactor, augLevel;

	if ( (CarriedDecoration != None) && (CarriedDecoration.Mass > 20) )
		return;
	else if ( bForceDuck || IsLeaning() )
		return;

	if ( Physics == PHYS_Walking )
	{
		if ( Role == ROLE_Authority )
			PlaySound(JumpSound, SLOT_None, 1.5, true, 1200, 1.0 - 0.05*FRand() );
		if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
			MakeNoise(0.1 * Level.Game.Difficulty);
		PlayInAir();

		Velocity.Z = JumpZ;
		
		//Fix for jumping on revbow darts, 3/2/20
		if ((Base != Level) && (Base != None) && (!Base.IsA('HatchetProjectile')))
			Velocity.Z += Base.Velocity.Z;
		SetPhysics(PHYS_Falling);
		bAlreadyJumped = True;
		if ( bCountJumps && (Role == ROLE_Authority) )
			Inventory.OwnerJumped();
	}

	else if ( (Physics == PHYS_Falling) && bCanAirJump && bAlreadyJumped)
	{
		if (Velocity.Z > 0)
		{
			bAlreadyJumped = False;
			if ( Role == ROLE_Authority )
				PlaySound(JumpSound, SLOT_None, 1.5, true, 1200, 1.0 - 0.05*FRand() );
			if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
				MakeNoise(0.1 * Level.Game.Difficulty);
			PlayInAir();
			
			Velocity.Z = JumpZ * 0.7; //vs 0.795
			SetPhysics(PHYS_Falling);
			if ( bCountJumps && (Role == ROLE_Authority) )
				Inventory.OwnerJumped();
		}
	}
}

}

exec function bool DropItem (optional Inventory Inv, optional bool bDrop)
{
	local byte VB7;
	local Inventory Item;
	local Inventory previousItemInHand;
	local Vector X;
	local Vector Y;
	local Vector Z;
	local Vector dropVect, dropVect2;
	local float size;
	local float Mult;
	local DeusExCarcass carc;
	local Class<DeusExCarcass> carcClass;
	local bool bDropped;
	local bool bRemovedFromSlots;
	local int itemPosX;
	local int itemPosY;
        local bool bInfectedAnalGland;

        //stuff copied from the hood ol' tantalus command
	local Actor            hitActor;
	local Vector           hitLocation, hitNormal;
	local Vector           position, line;
        //random variable used for calculations
        local Vector crap;
        

	position    = Location;
	position.Z += BaseEyeHeight;
//	line        = Vector(ViewRotation) * 4000;
//
	bDropped=True;
	if ( RestrictInput() )
	{
		return False;
	}
	if ( Inv == None )
	{
		previousItemInHand=inHand;
		Item=inHand;
	} else {
		Item=Inv;
	}
	if ( Item != None )
	{
		GetAxes(Rotation,X,Y,Z);
		dropVect=Location + (CollisionRadius + 2 * Item.CollisionRadius) * X;
		dropVect.Z += BaseEyeHeight;

        crap = vect(0,0,0);
        crap.X += (CollisionRadius + 2 * Item.CollisionRadius);

        

	hitActor = Trace(hitLocation, hitNormal, position+(crap >> ViewRotation), position, true);
        //log("TRACE ACTOR IN DROP HIT "$hitActor$"!");

		if ((  !FastTrace(dropVect) ) && (!hitActor.IsA('InvisibleWall')))
		{
			bInfectedAnalGland = True;
			return False;
		}
		if ( Item.IsA('DeusExWeapon') )
		{
			if (  !DeusExWeapon(Item).IsInState('Idle') &&  !DeusExWeapon(Item).IsInState('Idle2') &&  !DeusExWeapon(Item).IsInState('DownWeapon') &&  !DeusExWeapon(Item).IsInState('Reload') )
			{
				return False;
			} else {
				DeusExWeapon(Item).ScopeOff();
				DeusExWeapon(Item).LaserOff();
			}
		}
		if ( Item.IsA('ChargedPickup') && ChargedPickup(Item).IsActive() )
		{
			return False;
		}
		if ( Item.IsA('NanoKeyRing') )
		{
			return False;
		}
		if ( Item == inHand )
		{
			PutInHand(None);
		}
		if ( Item.IsA('DeusExPickup') )
		{
			if ( DeusExPickup(Item).bActive )
			{
				DeusExPickup(Item).Activate();
			}
			DeusExPickup(Item).NumCopies--;
			UpdateBeltText(Item);
			if ( DeusExPickup(Item).NumCopies > 0 )
			{
				if ( previousItemInHand == Item )
				{
					PutInHand(previousItemInHand);
				}
				Item=Spawn(Item.Class,Owner);
			} else {
				bRemovedFromSlots=True;
				itemPosX=Item.invPosX;
				itemPosY=Item.invPosY;
				RemoveItemFromSlot(Item);
				DeusExPickup(Item).NumCopies=1;
			}
		} else {
			bRemovedFromSlots=True;
			itemPosX=Item.invPosX;
			itemPosY=Item.invPosY;
			RemoveItemFromSlot(Item);
		}
		if ( (Level.NetMode == 0) && (FrobTarget != None) &&  !Item.IsA('POVCorpse') )
		{
			Item.Velocity=vect(0.00,0.00,0.00);
			PlayPickupAnim(FrobTarget.Location);
			size=FrobTarget.CollisionRadius - Item.CollisionRadius * 2;
			dropVect.X=size / 2 - FRand() * size;
			dropVect.Y=size / 2 - FRand() * size;
			dropVect.Z=FrobTarget.CollisionHeight + Item.CollisionHeight + 16;

			if (( FastTrace(dropVect) )  || (hitActor.IsA('InvisibleWall')))
			{
				Item.DropFrom(FrobTarget.Location + dropVect);
			}
			if (hitActor.IsA('InvisibleWall'))
			{
				Item.Velocity=Vector(ViewRotation) * Mult * 300 + vect(0.00,0.00,220.00) + 40 * VRand();
				PlayAnim('Attack',,0.10);
			}
			else if (( !FastTrace(dropVect) ) && (!hitActor.IsA('InvisibleWall')))
		        {
				bInfectedAnalGland = True;
				bDropped=False;
			}
		} else {
			if ( AugmentationSystem != None )
			{
				Mult=AugmentationSystem.GetAugLevelValue(Class'AugMuscle');
				if ( Mult == -1.00 )
				{
					Mult=1.00;
				}
			}
			if ( bDrop )
			{
				Item.Velocity=VRand() * 30;
				PlayPickupAnim(Item.Location);
			} else {
				Item.Velocity=Vector(ViewRotation) * Mult * 300 + vect(0.00,0.00,220.00) + 40 * VRand();
				PlayAnim('Attack',,0.10);
			}
			GetAxes(ViewRotation,X,Y,Z);
			dropVect=Location + 0.80 * CollisionRadius * X;
			dropVect.Z += BaseEyeHeight;
			if ( Item.IsA('POVCorpse') )
			{
				if ( POVCorpse(Item).carcClassString != "" )
				{
					carcClass=Class<DeusExCarcass>(DynamicLoadObject(POVCorpse(Item).carcClassString,Class'Class'));
					if ( carcClass != None )
					{
						carc=Spawn(carcClass);
						if ( carc != None )
						{
							carc.Mesh=carc.Mesh2;
							carc.KillerAlliance=POVCorpse(Item).KillerAlliance;
							carc.KillerBindName=POVCorpse(Item).KillerBindName;
							carc.Alliance=POVCorpse(Item).Alliance;
							carc.bNotDead=POVCorpse(Item).bNotDead;
							carc.bEmitCarcass=POVCorpse(Item).bEmitCarcass;
							carc.CumulativeDamage=POVCorpse(Item).CumulativeDamage;
							carc.MaxDamage=POVCorpse(Item).MaxDamage;
							carc.ItemName=POVCorpse(Item).CorpseItemName;
							carc.CarcassName=POVCorpse(Item).CarcassName;
							carc.Velocity=Item.Velocity * 0.50;
							Item.Velocity=vect(0.00,0.00,0.00);
							carc.bHidden=False;
							carc.SetPhysics(PHYS_Falling);
							carc.SetScaleGlow();
							if ( carc.SetLocation(dropVect) )
							{
								SetInHandPending(None);
								Item.Destroy();
								Item=None;
							} else {
								carc.bHidden=True;
							}
						}
					}
				}
			} else {
				if (( FastTrace(dropVect) )  || (hitActor.IsA('InvisibleWall')))
				{
					Item.DropFrom(dropVect);
					Item.bFixedRotationDir=True;
					Item.RotationRate.Pitch=(32768 - Rand(65536)) * 4.00;
					Item.RotationRate.Yaw=(32768 - Rand(65536)) * 4.00;
				}
			}
		}
		if ( Item != None )
		{
			if ( ((inHand == None) || (inHandPending == None)) && (Item.Physics != PHYS_Falling) )
			{
				PutInHand(Item);
				bInfectedAnalGland = True;
				bDropped=False;
			} else {
				Item.Instigator=self;
			}
		}
	} else {
		if ( carriedDecoration != None )
		{
			DropDecoration();
			PlayAnim('Attack',,0.10);
		}
	}
	if ( bRemovedFromSlots && (Item != None) &&  !bDropped )
	{
		PlaceItemInSlot(Item,itemPosX,itemPosY);
	}
        if ((bInfectedAnalGland) && (!hitActor.IsA('InvisibleWall')))
	 ClientMessage(CannotDropHere);
	return bDropped;
}

defaultproperties
{
    bReplaceHUD=False
    bAutoArmsMode=False
    LivesLeft=999
    ArmorComposition=0
    HasteRating=1.000000
    SpeedRating=1.000000
    
    //Testing for player model.
    //LODBias=50
    PlayerReplicationInfoClass=class'MSMTLPlayerReplicationInfo'
}
